%------------------------------------------------------------------------------
% File     : DAT113^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Data Structures
% Problem  : Coinductive list 24
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [Loc10] Lochbihler (2010), Coinductive
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : coinductive_list__24.p [Bla16]

% Status   : Theorem
% Rating   : 0.67 v8.1.0, 0.50 v7.5.0, 1.00 v7.2.0, 0.75 v7.1.0
% Syntax   : Number of formulae    :  289 (  52 unt;  36 typ;   0 def)
%            Number of atoms       :  855 ( 133 equ;   0 cnn)
%            Maximal formula atoms :   13 (   3 avg)
%            Number of connectives : 3387 (  79   ~;  26   |;  59   &;2643   @)
%                                         (   0 <=>; 580  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (  10 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  264 ( 264   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   35 (  34 usr;   2 con; 0-4 aty)
%            Number of variables   : 1031 (  46   ^; 909   !;  42   ?;1031   :)
%                                         (  34  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:42:11.560
%------------------------------------------------------------------------------
%----Could-be-implicit typings (4)
thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (32)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__bot,type,
    no_bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Ono__top,type,
    no_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__order,type,
    dense_order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Complete__Lattices_Ocomplete__lattice,type,
    comple187826305attice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Olinear__continuum,type,
    condit1656338222tinuum: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Conditionally__Complete__Lattices_Oconditionally__complete__linorder,type,
    condit1037483654norder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_Complete__Partial__Order_Ochain,type,
    comple1193779247_chain: 
      !>[A: $tType] : ( ( A > A > $o ) > ( set @ A ) > $o ) ).

thf(sy_c_Hilbert__Choice_OGreatestM,type,
    hilbert_GreatestM: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( A > $o ) > A ) ).

thf(sy_c_Hilbert__Choice_OLeastM,type,
    hilbert_LeastM: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( A > $o ) > A ) ).

thf(sy_c_Orderings_Oord__class_OLeast,type,
    ord_Least: 
      !>[A: $tType] : ( ( A > $o ) > A ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oorder__class_Oantimono,type,
    order_antimono: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > $o ) ).

thf(sy_c_Orderings_Oorder__class_Omono,type,
    order_mono: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > $o ) ).

thf(sy_c_Orderings_Oorder__class_Ostrict__mono,type,
    order_strict_mono: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > $o ) ).

thf(sy_c_Orderings_Oordering,type,
    ordering: 
      !>[A: $tType] : ( ( A > A > $o ) > ( A > A > $o ) > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Topological__Spaces_Omonoseq,type,
    topological_monoseq: 
      !>[A: $tType] : ( ( nat > A ) > $o ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_P,type,
    p: a > a > $o ).

thf(sy_v_a,type,
    a2: a ).

thf(sy_v_b,type,
    b: a ).

%----Relevant facts (227)
thf(fact_0_local_Osym,axiom,
    ( ( p @ b @ a2 )
   => ( p @ a2 @ b ) ) ).

% local.sym
thf(fact_1_le,axiom,
    ! [A2: a,B2: a] :
      ( ( ord_less_eq @ a @ A2 @ B2 )
     => ( p @ A2 @ B2 ) ) ).

% le
thf(fact_2_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_3_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funD
thf(fact_4_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funE
thf(fact_5_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B] :
          ( ! [X2: A] : ( ord_less_eq @ B @ ( F @ X2 ) @ ( G @ X2 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G ) ) ) ).

% le_funI
thf(fact_6_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
            ! [X3: A] : ( ord_less_eq @ B @ ( F2 @ X3 ) @ ( G2 @ X3 ) ) ) ) ) ).

% le_fun_def
thf(fact_7_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C )
           => ( ! [X2: B,Y: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_8_order__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C2 @ ( F @ B2 ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y )
                 => ( ord_less_eq @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_9_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( A2
            = ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C )
           => ( ! [X2: B,Y: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_10_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > B,C: B] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ( F @ B2 )
              = C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y )
                 => ( ord_less_eq @ B @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less_eq @ B @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_11_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y2: A,Z: A] : ( Y2 = Z ) )
        = ( ^ [X3: A,Y3: A] :
              ( ( ord_less_eq @ A @ X3 @ Y3 )
              & ( ord_less_eq @ A @ Y3 @ X3 ) ) ) ) ) ).

% eq_iff
thf(fact_12_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ X )
           => ( X = Y4 ) ) ) ) ).

% antisym
thf(fact_13_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
          | ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% linear
thf(fact_14_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( A2 = B2 ) ) ) ) ).

% dual_order.antisym
thf(fact_15_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C @ B2 )
           => ( ord_less_eq @ A @ C @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_16_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B2: A] :
          ( ! [A3: A,B3: A] :
              ( ( ord_less_eq @ A @ A3 @ B3 )
             => ( P @ A3 @ B3 ) )
         => ( ! [A3: A,B3: A] :
                ( ( P @ B3 @ A3 )
               => ( P @ A3 @ B3 ) )
           => ( P @ A2 @ B2 ) ) ) ) ).

% linorder_wlog
thf(fact_17_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_18_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,Z2: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ Z2 )
           => ( ord_less_eq @ A @ X @ Z2 ) ) ) ) ).

% order_trans
thf(fact_19_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ A2 )
           => ( A2 = B2 ) ) ) ) ).

% order_class.order.antisym
thf(fact_20_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( B2 = C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_21_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( A2 = B2 )
         => ( ( ord_less_eq @ A @ B2 @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_22_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y4: A,X: A] :
          ( ( ord_less_eq @ A @ Y4 @ X )
         => ( ( ord_less_eq @ A @ X @ Y4 )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv
thf(fact_23_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,Z2: A] :
          ( ( ( ord_less_eq @ A @ X @ Y4 )
           => ~ ( ord_less_eq @ A @ Y4 @ Z2 ) )
         => ( ( ( ord_less_eq @ A @ Y4 @ X )
             => ~ ( ord_less_eq @ A @ X @ Z2 ) )
           => ( ( ( ord_less_eq @ A @ X @ Z2 )
               => ~ ( ord_less_eq @ A @ Z2 @ Y4 ) )
             => ( ( ( ord_less_eq @ A @ Z2 @ Y4 )
                 => ~ ( ord_less_eq @ A @ Y4 @ X ) )
               => ( ( ( ord_less_eq @ A @ Y4 @ Z2 )
                   => ~ ( ord_less_eq @ A @ Z2 @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z2 @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y4 ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_24_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% order.trans
thf(fact_25_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y4 )
         => ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% le_cases
thf(fact_26_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( X = Y4 )
         => ( ord_less_eq @ A @ X @ Y4 ) ) ) ).

% eq_refl
thf(fact_27_lfp_Oleq__antisym,axiom,
    ! [A: $tType] :
      ( ( comple187826305attice @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ X )
           => ( X = Y4 ) ) ) ) ).

% lfp.leq_antisym
thf(fact_28_gfp_Oleq__antisym,axiom,
    ! [A: $tType] :
      ( ( comple187826305attice @ A @ ( type2 @ A ) )
     => ! [Y4: A,X: A] :
          ( ( ord_less_eq @ A @ Y4 @ X )
         => ( ( ord_less_eq @ A @ X @ Y4 )
           => ( X = Y4 ) ) ) ) ).

% gfp.leq_antisym
thf(fact_29_lfp_Oleq__trans,axiom,
    ! [A: $tType] :
      ( ( comple187826305attice @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,Z2: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ Z2 )
           => ( ord_less_eq @ A @ X @ Z2 ) ) ) ) ).

% lfp.leq_trans
thf(fact_30_gfp_Oleq__trans,axiom,
    ! [A: $tType] :
      ( ( comple187826305attice @ A @ ( type2 @ A ) )
     => ! [Y4: A,X: A,Z2: A] :
          ( ( ord_less_eq @ A @ Y4 @ X )
         => ( ( ord_less_eq @ A @ Z2 @ Y4 )
           => ( ord_less_eq @ A @ Z2 @ X ) ) ) ) ).

% gfp.leq_trans
thf(fact_31_lfp_Oleq__refl,axiom,
    ! [A: $tType] :
      ( ( comple187826305attice @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% lfp.leq_refl
thf(fact_32_strict__mono__less__eq,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( linorder @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_strict_mono @ A @ B @ F )
         => ( ( ord_less_eq @ B @ ( F @ X ) @ ( F @ Y4 ) )
            = ( ord_less_eq @ A @ X @ Y4 ) ) ) ) ).

% strict_mono_less_eq
thf(fact_33_antimono__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ( ( order_antimono @ A @ B )
        = ( ^ [F2: A > B] :
            ! [X3: A,Y3: A] :
              ( ( ord_less_eq @ A @ X3 @ Y3 )
             => ( ord_less_eq @ B @ ( F2 @ Y3 ) @ ( F2 @ X3 ) ) ) ) ) ) ).

% antimono_def
thf(fact_34_antimonoI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B] :
          ( ! [X2: A,Y: A] :
              ( ( ord_less_eq @ A @ X2 @ Y )
             => ( ord_less_eq @ B @ ( F @ Y ) @ ( F @ X2 ) ) )
         => ( order_antimono @ A @ B @ F ) ) ) ).

% antimonoI
thf(fact_35_antimonoE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_antimono @ A @ B @ F )
         => ( ( ord_less_eq @ A @ X @ Y4 )
           => ( ord_less_eq @ B @ ( F @ Y4 ) @ ( F @ X ) ) ) ) ) ).

% antimonoE
thf(fact_36_antimonoD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_antimono @ A @ B @ F )
         => ( ( ord_less_eq @ A @ X @ Y4 )
           => ( ord_less_eq @ B @ ( F @ Y4 ) @ ( F @ X ) ) ) ) ) ).

% antimonoD
thf(fact_37_LeastI2__wellorder__ex,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,Q: A > $o] :
          ( ? [X1: A] : ( P @ X1 )
         => ( ! [A3: A] :
                ( ( P @ A3 )
               => ( ! [B4: A] :
                      ( ( P @ B4 )
                     => ( ord_less_eq @ A @ A3 @ B4 ) )
                 => ( Q @ A3 ) ) )
           => ( Q @ ( ord_Least @ A @ P ) ) ) ) ) ).

% LeastI2_wellorder_ex
thf(fact_38_LeastI2__ex,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,Q: A > $o] :
          ( ? [X1: A] : ( P @ X1 )
         => ( ! [X2: A] :
                ( ( P @ X2 )
               => ( Q @ X2 ) )
           => ( Q @ ( ord_Least @ A @ P ) ) ) ) ) ).

% LeastI2_ex
thf(fact_39_LeastI__ex,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o] :
          ( ? [X1: A] : ( P @ X1 )
         => ( P @ ( ord_Least @ A @ P ) ) ) ) ).

% LeastI_ex
thf(fact_40_LeastI2,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,A2: A,Q: A > $o] :
          ( ( P @ A2 )
         => ( ! [X2: A] :
                ( ( P @ X2 )
               => ( Q @ X2 ) )
           => ( Q @ ( ord_Least @ A @ P ) ) ) ) ) ).

% LeastI2
thf(fact_41_strict__mono__eq,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( linorder @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_strict_mono @ A @ B @ F )
         => ( ( ( F @ X )
              = ( F @ Y4 ) )
            = ( X = Y4 ) ) ) ) ).

% strict_mono_eq
thf(fact_42_LeastI2__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [P: A > $o,X: A,Q: A > $o] :
          ( ( P @ X )
         => ( ! [Y: A] :
                ( ( P @ Y )
               => ( ord_less_eq @ A @ X @ Y ) )
           => ( ! [X2: A] :
                  ( ( P @ X2 )
                 => ( ! [Y5: A] :
                        ( ( P @ Y5 )
                       => ( ord_less_eq @ A @ X2 @ Y5 ) )
                   => ( Q @ X2 ) ) )
             => ( Q @ ( ord_Least @ A @ P ) ) ) ) ) ) ).

% LeastI2_order
thf(fact_43_Least__equality,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [P: A > $o,X: A] :
          ( ( P @ X )
         => ( ! [Y: A] :
                ( ( P @ Y )
               => ( ord_less_eq @ A @ X @ Y ) )
           => ( ( ord_Least @ A @ P )
              = X ) ) ) ) ).

% Least_equality
thf(fact_44_LeastI2__wellorder,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,A2: A,Q: A > $o] :
          ( ( P @ A2 )
         => ( ! [A3: A] :
                ( ( P @ A3 )
               => ( ! [B4: A] :
                      ( ( P @ B4 )
                     => ( ord_less_eq @ A @ A3 @ B4 ) )
                 => ( Q @ A3 ) ) )
           => ( Q @ ( ord_Least @ A @ P ) ) ) ) ) ).

% LeastI2_wellorder
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X3: A] : ( member @ A @ X3 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P @ X2 )
          = ( Q @ X2 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X2: A] :
          ( ( F @ X2 )
          = ( G @ X2 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_decseqD,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [F: nat > A,I: nat,J: nat] :
          ( ( order_antimono @ nat @ A @ F )
         => ( ( ord_less_eq @ nat @ I @ J )
           => ( ord_less_eq @ A @ ( F @ J ) @ ( F @ I ) ) ) ) ) ).

% decseqD
thf(fact_50_decseq__def,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( order_antimono @ nat @ A )
        = ( ^ [X4: nat > A] :
            ! [M: nat,N: nat] :
              ( ( ord_less_eq @ nat @ M @ N )
             => ( ord_less_eq @ A @ ( X4 @ N ) @ ( X4 @ M ) ) ) ) ) ) ).

% decseq_def
thf(fact_51_strict__mono__less,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( linorder @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_strict_mono @ A @ B @ F )
         => ( ( ord_less @ B @ ( F @ X ) @ ( F @ Y4 ) )
            = ( ord_less @ A @ X @ Y4 ) ) ) ) ).

% strict_mono_less
thf(fact_52_strict__mono__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ( ( order_strict_mono @ A @ B )
        = ( ^ [F2: A > B] :
            ! [X3: A,Y3: A] :
              ( ( ord_less @ A @ X3 @ Y3 )
             => ( ord_less @ B @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) ) ) ) ) ).

% strict_mono_def
thf(fact_53_strict__monoI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B] :
          ( ! [X2: A,Y: A] :
              ( ( ord_less @ A @ X2 @ Y )
             => ( ord_less @ B @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( order_strict_mono @ A @ B @ F ) ) ) ).

% strict_monoI
thf(fact_54_strict__monoD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_strict_mono @ A @ B @ F )
         => ( ( ord_less @ A @ X @ Y4 )
           => ( ord_less @ B @ ( F @ X ) @ ( F @ Y4 ) ) ) ) ) ).

% strict_monoD
thf(fact_55_strict__mono__mono,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B] :
          ( ( order_strict_mono @ A @ B @ F )
         => ( order_mono @ A @ B @ F ) ) ) ).

% strict_mono_mono
thf(fact_56_linorder__chain,axiom,
    ! [B: $tType] :
      ( ( linorder @ B @ ( type2 @ B ) )
     => ! [Y6: set @ B] : ( comple1193779247_chain @ B @ ( ord_less_eq @ B ) @ Y6 ) ) ).

% linorder_chain
thf(fact_57_LeastMI2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [P: A > $o,X: A,M2: A > B,Q: A > $o] :
          ( ( P @ X )
         => ( ! [Y: A] :
                ( ( P @ Y )
               => ( ord_less_eq @ B @ ( M2 @ X ) @ ( M2 @ Y ) ) )
           => ( ! [X2: A] :
                  ( ( P @ X2 )
                 => ( ! [Y5: A] :
                        ( ( P @ Y5 )
                       => ( ord_less_eq @ B @ ( M2 @ X2 ) @ ( M2 @ Y5 ) ) )
                   => ( Q @ X2 ) ) )
             => ( Q @ ( hilbert_LeastM @ A @ B @ M2 @ P ) ) ) ) ) ) ).

% LeastMI2
thf(fact_58_incseqD,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [F: nat > A,I: nat,J: nat] :
          ( ( order_mono @ nat @ A @ F )
         => ( ( ord_less_eq @ nat @ I @ J )
           => ( ord_less_eq @ A @ ( F @ I ) @ ( F @ J ) ) ) ) ) ).

% incseqD
thf(fact_59_incseq__def,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( order_mono @ nat @ A )
        = ( ^ [X4: nat > A] :
            ! [M: nat,N: nat] :
              ( ( ord_less_eq @ nat @ M @ N )
             => ( ord_less_eq @ A @ ( X4 @ M ) @ ( X4 @ N ) ) ) ) ) ) ).

% incseq_def
thf(fact_60_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( A2
            = ( F @ B2 ) )
         => ( ( ord_less @ B @ B2 @ C )
           => ( ! [X2: B,Y: B] :
                  ( ( ord_less @ B @ X2 @ Y )
                 => ( ord_less @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_less_subst
thf(fact_61_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > B,C: B] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ( F @ B2 )
              = C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less @ A @ X2 @ Y )
                 => ( ord_less @ B @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ B @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_less_eq_subst
thf(fact_62_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( ord_less @ A @ A2 @ ( F @ B2 ) )
         => ( ( ord_less @ B @ B2 @ C )
           => ( ! [X2: B,Y: B] :
                  ( ( ord_less @ B @ X2 @ Y )
                 => ( ord_less @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_less_subst1
thf(fact_63_order__less__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > C2,C: C2] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less @ C2 @ ( F @ B2 ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less @ A @ X2 @ Y )
                 => ( ord_less @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_less_subst2
thf(fact_64_lt__ex,axiom,
    ! [A: $tType] :
      ( ( no_bot @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [Y: A] : ( ord_less @ A @ Y @ X ) ) ).

% lt_ex
thf(fact_65_gt__ex,axiom,
    ! [A: $tType] :
      ( ( no_top @ A @ ( type2 @ A ) )
     => ! [X: A] :
        ? [X12: A] : ( ord_less @ A @ X @ X12 ) ) ).

% gt_ex
thf(fact_66_neqE,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( X != Y4 )
         => ( ~ ( ord_less @ A @ X @ Y4 )
           => ( ord_less @ A @ Y4 @ X ) ) ) ) ).

% neqE
thf(fact_67_neq__iff,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( X != Y4 )
          = ( ( ord_less @ A @ X @ Y4 )
            | ( ord_less @ A @ Y4 @ X ) ) ) ) ).

% neq_iff
thf(fact_68_order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ~ ( ord_less @ A @ B2 @ A2 ) ) ) ).

% order.asym
thf(fact_69_dense,axiom,
    ! [A: $tType] :
      ( ( dense_order @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ? [Z3: A] :
              ( ( ord_less @ A @ X @ Z3 )
              & ( ord_less @ A @ Z3 @ Y4 ) ) ) ) ).

% dense
thf(fact_70_less__imp__neq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( X != Y4 ) ) ) ).

% less_imp_neq
thf(fact_71_less__asym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ~ ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_asym
thf(fact_72_less__asym_H,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ~ ( ord_less @ A @ B2 @ A2 ) ) ) ).

% less_asym'
thf(fact_73_less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,Z2: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less @ A @ Y4 @ Z2 )
           => ( ord_less @ A @ X @ Z2 ) ) ) ) ).

% less_trans
thf(fact_74_less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
          | ( X = Y4 )
          | ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_linear
thf(fact_75_less__irrefl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] :
          ~ ( ord_less @ A @ X @ X ) ) ).

% less_irrefl
thf(fact_76_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( A2 = B2 )
         => ( ( ord_less @ A @ B2 @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% ord_eq_less_trans
thf(fact_77_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( B2 = C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% ord_less_eq_trans
thf(fact_78_dual__order_Oasym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ~ ( ord_less @ A @ A2 @ B2 ) ) ) ).

% dual_order.asym
thf(fact_79_less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( X != Y4 ) ) ) ).

% less_imp_not_eq
thf(fact_80_less__not__sym,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ~ ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_not_sym
thf(fact_81_less__induct,axiom,
    ! [A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,A2: A] :
          ( ! [X2: A] :
              ( ! [Y5: A] :
                  ( ( ord_less @ A @ Y5 @ X2 )
                 => ( P @ Y5 ) )
             => ( P @ X2 ) )
         => ( P @ A2 ) ) ) ).

% less_induct
thf(fact_82_antisym__conv3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y4: A,X: A] :
          ( ~ ( ord_less @ A @ Y4 @ X )
         => ( ( ~ ( ord_less @ A @ X @ Y4 ) )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv3
thf(fact_83_less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( Y4 != X ) ) ) ).

% less_imp_not_eq2
thf(fact_84_less__imp__triv,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,P: $o] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less @ A @ Y4 @ X )
           => P ) ) ) ).

% less_imp_triv
thf(fact_85_linorder__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less @ A @ X @ Y4 )
         => ( ( X != Y4 )
           => ( ord_less @ A @ Y4 @ X ) ) ) ) ).

% linorder_cases
thf(fact_86_dual__order_Oirrefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] :
          ~ ( ord_less @ A @ A2 @ A2 ) ) ).

% dual_order.irrefl
thf(fact_87_order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less @ A @ B2 @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans
thf(fact_88_less__imp__not__less,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ~ ( ord_less @ A @ Y4 @ X ) ) ) ).

% less_imp_not_less
thf(fact_89_dual__order_Ostrict__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( ( ord_less @ A @ C @ B2 )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans
thf(fact_90_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ~ ( ord_less @ A @ X @ Y4 ) )
          = ( ( ord_less @ A @ Y4 @ X )
            | ( X = Y4 ) ) ) ) ).

% not_less_iff_gr_or_eq
thf(fact_91_order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( A2 != B2 ) ) ) ).

% order.strict_implies_not_eq
thf(fact_92_dual__order_Ostrict__implies__not__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( A2 != B2 ) ) ) ).

% dual_order.strict_implies_not_eq
thf(fact_93_mono__invE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( linorder @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_mono @ A @ B @ F )
         => ( ( ord_less @ B @ ( F @ X ) @ ( F @ Y4 ) )
           => ( ord_less_eq @ A @ X @ Y4 ) ) ) ) ).

% mono_invE
thf(fact_94_ex__has__greatest__nat,axiom,
    ! [A: $tType,P: A > $o,K: A,M2: A > nat,B2: nat] :
      ( ( P @ K )
     => ( ! [Y: A] :
            ( ( P @ Y )
           => ( ord_less @ nat @ ( M2 @ Y ) @ B2 ) )
       => ? [X2: A] :
            ( ( P @ X2 )
            & ! [Y5: A] :
                ( ( P @ Y5 )
               => ( ord_less_eq @ nat @ ( M2 @ Y5 ) @ ( M2 @ X2 ) ) ) ) ) ) ).

% ex_has_greatest_nat
thf(fact_95_ex__has__least__nat,axiom,
    ! [A: $tType,P: A > $o,K: A,M2: A > nat] :
      ( ( P @ K )
     => ? [X2: A] :
          ( ( P @ X2 )
          & ! [Y5: A] :
              ( ( P @ Y5 )
             => ( ord_less_eq @ nat @ ( M2 @ X2 ) @ ( M2 @ Y5 ) ) ) ) ) ).

% ex_has_least_nat
thf(fact_96_LeastM__nat__lemma,axiom,
    ! [A: $tType,P: A > $o,K: A,M2: A > nat] :
      ( ( P @ K )
     => ( ( P @ ( hilbert_LeastM @ A @ nat @ M2 @ P ) )
        & ! [Y5: A] :
            ( ( P @ Y5 )
           => ( ord_less_eq @ nat @ ( M2 @ ( hilbert_LeastM @ A @ nat @ M2 @ P ) ) @ ( M2 @ Y5 ) ) ) ) ) ).

% LeastM_nat_lemma
thf(fact_97_LeastM__nat__le,axiom,
    ! [A: $tType,P: A > $o,X: A,M2: A > nat] :
      ( ( P @ X )
     => ( ord_less_eq @ nat @ ( M2 @ ( hilbert_LeastM @ A @ nat @ M2 @ P ) ) @ ( M2 @ X ) ) ) ).

% LeastM_nat_le
thf(fact_98_mono__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ( ( order_mono @ A @ B )
        = ( ^ [F2: A > B] :
            ! [X3: A,Y3: A] :
              ( ( ord_less_eq @ A @ X3 @ Y3 )
             => ( ord_less_eq @ B @ ( F2 @ X3 ) @ ( F2 @ Y3 ) ) ) ) ) ) ).

% mono_def
thf(fact_99_monoI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B] :
          ( ! [X2: A,Y: A] :
              ( ( ord_less_eq @ A @ X2 @ Y )
             => ( ord_less_eq @ B @ ( F @ X2 ) @ ( F @ Y ) ) )
         => ( order_mono @ A @ B @ F ) ) ) ).

% monoI
thf(fact_100_monoE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_mono @ A @ B @ F )
         => ( ( ord_less_eq @ A @ X @ Y4 )
           => ( ord_less_eq @ B @ ( F @ X ) @ ( F @ Y4 ) ) ) ) ) ).

% monoE
thf(fact_101_monoD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ( order @ A @ ( type2 @ A ) )
        & ( order @ B @ ( type2 @ B ) ) )
     => ! [F: A > B,X: A,Y4: A] :
          ( ( order_mono @ A @ B @ F )
         => ( ( ord_less_eq @ A @ X @ Y4 )
           => ( ord_less_eq @ B @ ( F @ X ) @ ( F @ Y4 ) ) ) ) ) ).

% monoD
thf(fact_102_order_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( A2 != B2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( ord_less @ A @ A2 @ B2 ) ) ) ) ).

% order.not_eq_order_implies_strict
thf(fact_103_dual__order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( ord_less_eq @ A @ B2 @ A2 ) ) ) ).

% dual_order.strict_implies_order
thf(fact_104_dual__order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [B5: A,A5: A] :
              ( ( ord_less_eq @ A @ B5 @ A5 )
              & ( A5 != B5 ) ) ) ) ) ).

% dual_order.strict_iff_order
thf(fact_105_dual__order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [B5: A,A5: A] :
              ( ( ord_less @ A @ B5 @ A5 )
              | ( A5 = B5 ) ) ) ) ) ).

% dual_order.order_iff_strict
thf(fact_106_order_Ostrict__implies__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ord_less_eq @ A @ A2 @ B2 ) ) ) ).

% order.strict_implies_order
thf(fact_107_dense__le__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,Z2: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ! [W: A] :
                ( ( ord_less @ A @ X @ W )
               => ( ( ord_less @ A @ W @ Y4 )
                 => ( ord_less_eq @ A @ W @ Z2 ) ) )
           => ( ord_less_eq @ A @ Y4 @ Z2 ) ) ) ) ).

% dense_le_bounded
thf(fact_108_dense__ge__bounded,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z2: A,X: A,Y4: A] :
          ( ( ord_less @ A @ Z2 @ X )
         => ( ! [W: A] :
                ( ( ord_less @ A @ Z2 @ W )
               => ( ( ord_less @ A @ W @ X )
                 => ( ord_less_eq @ A @ Y4 @ W ) ) )
           => ( ord_less_eq @ A @ Y4 @ Z2 ) ) ) ) ).

% dense_ge_bounded
thf(fact_109_dual__order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( ord_less @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C @ B2 )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans2
thf(fact_110_dual__order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less @ A @ C @ B2 )
           => ( ord_less @ A @ C @ A2 ) ) ) ) ).

% dual_order.strict_trans1
thf(fact_111_order_Ostrict__iff__order,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [A5: A,B5: A] :
              ( ( ord_less_eq @ A @ A5 @ B5 )
              & ( A5 != B5 ) ) ) ) ) ).

% order.strict_iff_order
thf(fact_112_order_Oorder__iff__strict,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [A5: A,B5: A] :
              ( ( ord_less @ A @ A5 @ B5 )
              | ( A5 = B5 ) ) ) ) ) ).

% order.order_iff_strict
thf(fact_113_order_Ostrict__trans2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans2
thf(fact_114_order_Ostrict__trans1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less @ A @ B2 @ C )
           => ( ord_less @ A @ A2 @ C ) ) ) ) ).

% order.strict_trans1
thf(fact_115_not__le__imp__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y4: A,X: A] :
          ( ~ ( ord_less_eq @ A @ Y4 @ X )
         => ( ord_less @ A @ X @ Y4 ) ) ) ).

% not_le_imp_less
thf(fact_116_less__le__not__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X3: A,Y3: A] :
              ( ( ord_less_eq @ A @ X3 @ Y3 )
              & ~ ( ord_less_eq @ A @ Y3 @ X3 ) ) ) ) ) ).

% less_le_not_le
thf(fact_117_le__imp__less__or__eq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less @ A @ X @ Y4 )
            | ( X = Y4 ) ) ) ) ).

% le_imp_less_or_eq
thf(fact_118_le__less__linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
          | ( ord_less @ A @ Y4 @ X ) ) ) ).

% le_less_linear
thf(fact_119_dense__le,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Y4: A,Z2: A] :
          ( ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Y4 )
             => ( ord_less_eq @ A @ X2 @ Z2 ) )
         => ( ord_less_eq @ A @ Y4 @ Z2 ) ) ) ).

% dense_le
thf(fact_120_dense__ge,axiom,
    ! [A: $tType] :
      ( ( dense_linorder @ A @ ( type2 @ A ) )
     => ! [Z2: A,Y4: A] :
          ( ! [X2: A] :
              ( ( ord_less @ A @ Z2 @ X2 )
             => ( ord_less_eq @ A @ Y4 @ X2 ) )
         => ( ord_less_eq @ A @ Y4 @ Z2 ) ) ) ).

% dense_ge
thf(fact_121_less__le__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,Z2: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ Y4 @ Z2 )
           => ( ord_less @ A @ X @ Z2 ) ) ) ) ).

% less_le_trans
thf(fact_122_le__less__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A,Z2: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ord_less @ A @ Y4 @ Z2 )
           => ( ord_less @ A @ X @ Z2 ) ) ) ) ).

% le_less_trans
thf(fact_123_antisym__conv2,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less_eq @ A @ X @ Y4 )
         => ( ( ~ ( ord_less @ A @ X @ Y4 ) )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv2
thf(fact_124_antisym__conv1,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less @ A @ X @ Y4 )
         => ( ( ord_less_eq @ A @ X @ Y4 )
            = ( X = Y4 ) ) ) ) ).

% antisym_conv1
thf(fact_125_less__imp__le,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ord_less @ A @ X @ Y4 )
         => ( ord_less_eq @ A @ X @ Y4 ) ) ) ).

% less_imp_le
thf(fact_126_le__neq__trans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( A2 != B2 )
           => ( ord_less @ A @ A2 @ B2 ) ) ) ) ).

% le_neq_trans
thf(fact_127_not__less,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ~ ( ord_less @ A @ X @ Y4 ) )
          = ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% not_less
thf(fact_128_not__le,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( ~ ( ord_less_eq @ A @ X @ Y4 ) )
          = ( ord_less @ A @ Y4 @ X ) ) ) ).

% not_le
thf(fact_129_order__less__le__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > C2,C: C2] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C2 @ ( F @ B2 ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less @ A @ X2 @ Y )
                 => ( ord_less @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_less_le_subst2
thf(fact_130_order__less__le__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( ord_less @ A @ A2 @ ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C )
           => ( ! [X2: B,Y: B] :
                  ( ( ord_less_eq @ B @ X2 @ Y )
                 => ( ord_less_eq @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_less_le_subst1
thf(fact_131_order__le__less__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less @ C2 @ ( F @ B2 ) @ C )
           => ( ! [X2: A,Y: A] :
                  ( ( ord_less_eq @ A @ X2 @ Y )
                 => ( ord_less_eq @ C2 @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_le_less_subst2
thf(fact_132_order__le__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B2 ) )
         => ( ( ord_less @ B @ B2 @ C )
           => ( ! [X2: B,Y: B] :
                  ( ( ord_less @ B @ X2 @ Y )
                 => ( ord_less @ A @ ( F @ X2 ) @ ( F @ Y ) ) )
             => ( ord_less @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_le_less_subst1
thf(fact_133_less__le,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less @ A )
        = ( ^ [X3: A,Y3: A] :
              ( ( ord_less_eq @ A @ X3 @ Y3 )
              & ( X3 != Y3 ) ) ) ) ) ).

% less_le
thf(fact_134_le__less,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ord_less_eq @ A )
        = ( ^ [X3: A,Y3: A] :
              ( ( ord_less @ A @ X3 @ Y3 )
              | ( X3 = Y3 ) ) ) ) ) ).

% le_less
thf(fact_135_leI,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ~ ( ord_less @ A @ X @ Y4 )
         => ( ord_less_eq @ A @ Y4 @ X ) ) ) ).

% leI
thf(fact_136_leD,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [Y4: A,X: A] :
          ( ( ord_less_eq @ A @ Y4 @ X )
         => ~ ( ord_less @ A @ X @ Y4 ) ) ) ).

% leD
thf(fact_137_less__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
              ( ( ord_less_eq @ ( A > B ) @ F2 @ G2 )
              & ~ ( ord_less_eq @ ( A > B ) @ G2 @ F2 ) ) ) ) ) ).

% less_fun_def
thf(fact_138_minf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ~ ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% minf(8)
thf(fact_139_minf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% minf(6)
thf(fact_140_pinf_I8_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( ord_less_eq @ A @ T @ X5 ) ) ) ).

% pinf(8)
thf(fact_141_pinf_I6_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ~ ( ord_less_eq @ A @ X5 @ T ) ) ) ).

% pinf(6)
thf(fact_142_complete__interval,axiom,
    ! [A: $tType] :
      ( ( condit1037483654norder @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,P: A > $o] :
          ( ( ord_less @ A @ A2 @ B2 )
         => ( ( P @ A2 )
           => ( ~ ( P @ B2 )
             => ? [C3: A] :
                  ( ( ord_less_eq @ A @ A2 @ C3 )
                  & ( ord_less_eq @ A @ C3 @ B2 )
                  & ! [X5: A] :
                      ( ( ( ord_less_eq @ A @ A2 @ X5 )
                        & ( ord_less @ A @ X5 @ C3 ) )
                     => ( P @ X5 ) )
                  & ! [D: A] :
                      ( ! [X2: A] :
                          ( ( ( ord_less_eq @ A @ A2 @ X2 )
                            & ( ord_less @ A @ X2 @ D ) )
                         => ( P @ X2 ) )
                     => ( ord_less_eq @ A @ D @ C3 ) ) ) ) ) ) ) ).

% complete_interval
thf(fact_143_chain__equality,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( comple1193779247_chain @ A
        @ ^ [Y2: A,Z: A] : ( Y2 = Z )
        @ A4 )
      = ( ! [X3: A] :
            ( ( member @ A @ X3 @ A4 )
           => ! [Y3: A] :
                ( ( member @ A @ Y3 @ A4 )
               => ( X3 = Y3 ) ) ) ) ) ).

% chain_equality
thf(fact_144_chain__def,axiom,
    ! [A: $tType] :
      ( ( comple1193779247_chain @ A )
      = ( ^ [Ord: A > A > $o,S: set @ A] :
          ! [X3: A] :
            ( ( member @ A @ X3 @ S )
           => ! [Y3: A] :
                ( ( member @ A @ Y3 @ S )
               => ( ( Ord @ X3 @ Y3 )
                  | ( Ord @ Y3 @ X3 ) ) ) ) ) ) ).

% chain_def
thf(fact_145_LeastM__natI,axiom,
    ! [A: $tType,P: A > $o,K: A,M2: A > nat] :
      ( ( P @ K )
     => ( P @ ( hilbert_LeastM @ A @ nat @ M2 @ P ) ) ) ).

% LeastM_natI
thf(fact_146_minf_I11_J,axiom,
    ! [C2: $tType,D2: $tType] :
      ( ( ord @ C2 @ ( type2 @ C2 ) )
     => ! [F3: D2] :
        ? [Z3: C2] :
        ! [X5: C2] :
          ( ( ord_less @ C2 @ X5 @ Z3 )
         => ( F3 = F3 ) ) ) ).

% minf(11)
thf(fact_147_minf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ~ ( ord_less @ A @ T @ X5 ) ) ) ).

% minf(7)
thf(fact_148_minf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( ord_less @ A @ X5 @ T ) ) ) ).

% minf(5)
thf(fact_149_minf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( X5 != T ) ) ) ).

% minf(4)
thf(fact_150_minf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ X5 @ Z3 )
         => ( X5 != T ) ) ) ).

% minf(3)
thf(fact_151_minf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Z4 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z4: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ X2 @ Z4 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z3 )
               => ( ( ( P @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(2)
thf(fact_152_minf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ X2 @ Z4 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z4: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ X2 @ Z4 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ X5 @ Z3 )
               => ( ( ( P @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% minf(1)
thf(fact_153_pinf_I11_J,axiom,
    ! [C2: $tType,D2: $tType] :
      ( ( ord @ C2 @ ( type2 @ C2 ) )
     => ! [F3: D2] :
        ? [Z3: C2] :
        ! [X5: C2] :
          ( ( ord_less @ C2 @ Z3 @ X5 )
         => ( F3 = F3 ) ) ) ).

% pinf(11)
thf(fact_154_pinf_I7_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( ord_less @ A @ T @ X5 ) ) ) ).

% pinf(7)
thf(fact_155_pinf_I5_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ~ ( ord_less @ A @ X5 @ T ) ) ) ).

% pinf(5)
thf(fact_156_pinf_I4_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(4)
thf(fact_157_pinf_I3_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [T: A] :
        ? [Z3: A] :
        ! [X5: A] :
          ( ( ord_less @ A @ Z3 @ X5 )
         => ( X5 != T ) ) ) ).

% pinf(3)
thf(fact_158_pinf_I2_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ Z4 @ X2 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z4: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ Z4 @ X2 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z3 @ X5 )
               => ( ( ( P @ X5 )
                    | ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    | ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(2)
thf(fact_159_pinf_I1_J,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > $o,P2: A > $o,Q: A > $o,Q2: A > $o] :
          ( ? [Z4: A] :
            ! [X2: A] :
              ( ( ord_less @ A @ Z4 @ X2 )
             => ( ( P @ X2 )
                = ( P2 @ X2 ) ) )
         => ( ? [Z4: A] :
              ! [X2: A] :
                ( ( ord_less @ A @ Z4 @ X2 )
               => ( ( Q @ X2 )
                  = ( Q2 @ X2 ) ) )
           => ? [Z3: A] :
              ! [X5: A] :
                ( ( ord_less @ A @ Z3 @ X5 )
               => ( ( ( P @ X5 )
                    & ( Q @ X5 ) )
                  = ( ( P2 @ X5 )
                    & ( Q2 @ X5 ) ) ) ) ) ) ) ).

% pinf(1)
thf(fact_160_ex__gt__or__lt,axiom,
    ! [A: $tType] :
      ( ( condit1656338222tinuum @ A @ ( type2 @ A ) )
     => ! [A2: A] :
        ? [B3: A] :
          ( ( ord_less @ A @ A2 @ B3 )
          | ( ord_less @ A @ B3 @ A2 ) ) ) ).

% ex_gt_or_lt
thf(fact_161_chain__subset,axiom,
    ! [A: $tType,Ord2: A > A > $o,A4: set @ A,B6: set @ A] :
      ( ( comple1193779247_chain @ A @ Ord2 @ A4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B6 @ A4 )
       => ( comple1193779247_chain @ A @ Ord2 @ B6 ) ) ) ).

% chain_subset
thf(fact_162_chainD,axiom,
    ! [A: $tType,Ord2: A > A > $o,S2: set @ A,X: A,Y4: A] :
      ( ( comple1193779247_chain @ A @ Ord2 @ S2 )
     => ( ( member @ A @ X @ S2 )
       => ( ( member @ A @ Y4 @ S2 )
         => ( ( Ord2 @ X @ Y4 )
            | ( Ord2 @ Y4 @ X ) ) ) ) ) ).

% chainD
thf(fact_163_chainE,axiom,
    ! [A: $tType,Ord2: A > A > $o,S2: set @ A,X: A,Y4: A] :
      ( ( comple1193779247_chain @ A @ Ord2 @ S2 )
     => ( ( member @ A @ X @ S2 )
       => ( ( member @ A @ Y4 @ S2 )
         => ( ~ ( Ord2 @ X @ Y4 )
           => ( Ord2 @ Y4 @ X ) ) ) ) ) ).

% chainE
thf(fact_164_chainI,axiom,
    ! [A: $tType,S2: set @ A,Ord2: A > A > $o] :
      ( ! [X2: A,Y: A] :
          ( ( member @ A @ X2 @ S2 )
         => ( ( member @ A @ Y @ S2 )
           => ( ( Ord2 @ X2 @ Y )
              | ( Ord2 @ Y @ X2 ) ) ) )
     => ( comple1193779247_chain @ A @ Ord2 @ S2 ) ) ).

% chainI
thf(fact_165_nat__less__le,axiom,
    ( ( ord_less @ nat )
    = ( ^ [M: nat,N: nat] :
          ( ( ord_less_eq @ nat @ M @ N )
          & ( M != N ) ) ) ) ).

% nat_less_le
thf(fact_166_less__imp__le__nat,axiom,
    ! [M2: nat,N2: nat] :
      ( ( ord_less @ nat @ M2 @ N2 )
     => ( ord_less_eq @ nat @ M2 @ N2 ) ) ).

% less_imp_le_nat
thf(fact_167_le__eq__less__or__eq,axiom,
    ( ( ord_less_eq @ nat )
    = ( ^ [M: nat,N: nat] :
          ( ( ord_less @ nat @ M @ N )
          | ( M = N ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_168_nat__neq__iff,axiom,
    ! [M2: nat,N2: nat] :
      ( ( M2 != N2 )
      = ( ( ord_less @ nat @ M2 @ N2 )
        | ( ord_less @ nat @ N2 @ M2 ) ) ) ).

% nat_neq_iff
thf(fact_169_less__not__refl,axiom,
    ! [N2: nat] :
      ~ ( ord_less @ nat @ N2 @ N2 ) ).

% less_not_refl
thf(fact_170_less__not__refl2,axiom,
    ! [N2: nat,M2: nat] :
      ( ( ord_less @ nat @ N2 @ M2 )
     => ( M2 != N2 ) ) ).

% less_not_refl2
thf(fact_171_less__not__refl3,axiom,
    ! [S3: nat,T: nat] :
      ( ( ord_less @ nat @ S3 @ T )
     => ( S3 != T ) ) ).

% less_not_refl3
thf(fact_172_measure__induct,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X2: A] :
          ( ! [Y5: A] :
              ( ( ord_less @ nat @ ( F @ Y5 ) @ ( F @ X2 ) )
             => ( P @ Y5 ) )
         => ( P @ X2 ) )
     => ( P @ A2 ) ) ).

% measure_induct
thf(fact_173_less__irrefl__nat,axiom,
    ! [N2: nat] :
      ~ ( ord_less @ nat @ N2 @ N2 ) ).

% less_irrefl_nat
thf(fact_174_nat__less__induct,axiom,
    ! [P: nat > $o,N2: nat] :
      ( ! [N3: nat] :
          ( ! [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
             => ( P @ M3 ) )
         => ( P @ N3 ) )
     => ( P @ N2 ) ) ).

% nat_less_induct
thf(fact_175_infinite__descent,axiom,
    ! [P: nat > $o,N2: nat] :
      ( ! [N3: nat] :
          ( ~ ( P @ N3 )
         => ? [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N3 )
              & ~ ( P @ M3 ) ) )
     => ( P @ N2 ) ) ).

% infinite_descent
thf(fact_176_linorder__neqE__nat,axiom,
    ! [X: nat,Y4: nat] :
      ( ( X != Y4 )
     => ( ~ ( ord_less @ nat @ X @ Y4 )
       => ( ord_less @ nat @ Y4 @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_177_measure__induct__rule,axiom,
    ! [A: $tType,F: A > nat,P: A > $o,A2: A] :
      ( ! [X2: A] :
          ( ! [Y5: A] :
              ( ( ord_less @ nat @ ( F @ Y5 ) @ ( F @ X2 ) )
             => ( P @ Y5 ) )
         => ( P @ X2 ) )
     => ( P @ A2 ) ) ).

% measure_induct_rule
thf(fact_178_infinite__descent__measure,axiom,
    ! [A: $tType,P: A > $o,V: A > nat,X: A] :
      ( ! [X2: A] :
          ( ~ ( P @ X2 )
         => ? [Y5: A] :
              ( ( ord_less @ nat @ ( V @ Y5 ) @ ( V @ X2 ) )
              & ~ ( P @ Y5 ) ) )
     => ( P @ X ) ) ).

% infinite_descent_measure
thf(fact_179_nat__le__linear,axiom,
    ! [M2: nat,N2: nat] :
      ( ( ord_less_eq @ nat @ M2 @ N2 )
      | ( ord_less_eq @ nat @ N2 @ M2 ) ) ).

% nat_le_linear
thf(fact_180_le__antisym,axiom,
    ! [M2: nat,N2: nat] :
      ( ( ord_less_eq @ nat @ M2 @ N2 )
     => ( ( ord_less_eq @ nat @ N2 @ M2 )
       => ( M2 = N2 ) ) ) ).

% le_antisym
thf(fact_181_eq__imp__le,axiom,
    ! [M2: nat,N2: nat] :
      ( ( M2 = N2 )
     => ( ord_less_eq @ nat @ M2 @ N2 ) ) ).

% eq_imp_le
thf(fact_182_le__trans,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less_eq @ nat @ I @ J )
     => ( ( ord_less_eq @ nat @ J @ K )
       => ( ord_less_eq @ nat @ I @ K ) ) ) ).

% le_trans
thf(fact_183_le__refl,axiom,
    ! [N2: nat] : ( ord_less_eq @ nat @ N2 @ N2 ) ).

% le_refl
thf(fact_184_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I: nat,J: nat] :
      ( ! [I2: nat,J2: nat] :
          ( ( ord_less @ nat @ I2 @ J2 )
         => ( ord_less @ nat @ ( F @ I2 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq @ nat @ I @ J )
       => ( ord_less_eq @ nat @ ( F @ I ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_185_le__neq__implies__less,axiom,
    ! [M2: nat,N2: nat] :
      ( ( ord_less_eq @ nat @ M2 @ N2 )
     => ( ( M2 != N2 )
       => ( ord_less @ nat @ M2 @ N2 ) ) ) ).

% le_neq_implies_less
thf(fact_186_less__or__eq__imp__le,axiom,
    ! [M2: nat,N2: nat] :
      ( ( ( ord_less @ nat @ M2 @ N2 )
        | ( M2 = N2 ) )
     => ( ord_less_eq @ nat @ M2 @ N2 ) ) ).

% less_or_eq_imp_le
thf(fact_187_psubsetI,axiom,
    ! [A: $tType,A4: set @ A,B6: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B6 )
     => ( ( A4 != B6 )
       => ( ord_less @ ( set @ A ) @ A4 @ B6 ) ) ) ).

% psubsetI
thf(fact_188_GreatestM__nat__lemma,axiom,
    ! [A: $tType,P: A > $o,K: A,M2: A > nat,B2: nat] :
      ( ( P @ K )
     => ( ! [Y: A] :
            ( ( P @ Y )
           => ( ord_less @ nat @ ( M2 @ Y ) @ B2 ) )
       => ( ( P @ ( hilbert_GreatestM @ A @ nat @ M2 @ P ) )
          & ! [Y5: A] :
              ( ( P @ Y5 )
             => ( ord_less_eq @ nat @ ( M2 @ Y5 ) @ ( M2 @ ( hilbert_GreatestM @ A @ nat @ M2 @ P ) ) ) ) ) ) ) ).

% GreatestM_nat_lemma
thf(fact_189_GreatestM__nat__le,axiom,
    ! [A: $tType,P: A > $o,X: A,M2: A > nat,B2: nat] :
      ( ( P @ X )
     => ( ! [Y: A] :
            ( ( P @ Y )
           => ( ord_less @ nat @ ( M2 @ Y ) @ B2 ) )
       => ( ord_less_eq @ nat @ ( M2 @ X ) @ ( M2 @ ( hilbert_GreatestM @ A @ nat @ M2 @ P ) ) ) ) ) ).

% GreatestM_nat_le
thf(fact_190_psubsetD,axiom,
    ! [A: $tType,A4: set @ A,B6: set @ A,C: A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B6 )
     => ( ( member @ A @ C @ A4 )
       => ( member @ A @ C @ B6 ) ) ) ).

% psubsetD
thf(fact_191_psubset__trans,axiom,
    ! [A: $tType,A4: set @ A,B6: set @ A,C4: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B6 )
     => ( ( ord_less @ ( set @ A ) @ B6 @ C4 )
       => ( ord_less @ ( set @ A ) @ A4 @ C4 ) ) ) ).

% psubset_trans
thf(fact_192_GreatestM__natI,axiom,
    ! [A: $tType,P: A > $o,K: A,M2: A > nat,B2: nat] :
      ( ( P @ K )
     => ( ! [Y: A] :
            ( ( P @ Y )
           => ( ord_less @ nat @ ( M2 @ Y ) @ B2 ) )
       => ( P @ ( hilbert_GreatestM @ A @ nat @ M2 @ P ) ) ) ) ).

% GreatestM_natI
thf(fact_193_GreatestMI2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [P: A > $o,X: A,M2: A > B,Q: A > $o] :
          ( ( P @ X )
         => ( ! [Y: A] :
                ( ( P @ Y )
               => ( ord_less_eq @ B @ ( M2 @ Y ) @ ( M2 @ X ) ) )
           => ( ! [X2: A] :
                  ( ( P @ X2 )
                 => ( ! [Y5: A] :
                        ( ( P @ Y5 )
                       => ( ord_less_eq @ B @ ( M2 @ Y5 ) @ ( M2 @ X2 ) ) )
                   => ( Q @ X2 ) ) )
             => ( Q @ ( hilbert_GreatestM @ A @ B @ M2 @ P ) ) ) ) ) ) ).

% GreatestMI2
thf(fact_194_psubsetE,axiom,
    ! [A: $tType,A4: set @ A,B6: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B6 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A4 @ B6 )
         => ( ord_less_eq @ ( set @ A ) @ B6 @ A4 ) ) ) ).

% psubsetE
thf(fact_195_psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A6: set @ A,B7: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A6 @ B7 )
            & ( A6 != B7 ) ) ) ) ).

% psubset_eq
thf(fact_196_psubset__imp__subset,axiom,
    ! [A: $tType,A4: set @ A,B6: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B6 )
     => ( ord_less_eq @ ( set @ A ) @ A4 @ B6 ) ) ).

% psubset_imp_subset
thf(fact_197_psubset__subset__trans,axiom,
    ! [A: $tType,A4: set @ A,B6: set @ A,C4: set @ A] :
      ( ( ord_less @ ( set @ A ) @ A4 @ B6 )
     => ( ( ord_less_eq @ ( set @ A ) @ B6 @ C4 )
       => ( ord_less @ ( set @ A ) @ A4 @ C4 ) ) ) ).

% psubset_subset_trans
thf(fact_198_subset__not__subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less @ ( set @ A ) )
      = ( ^ [A6: set @ A,B7: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A6 @ B7 )
            & ~ ( ord_less_eq @ ( set @ A ) @ B7 @ A6 ) ) ) ) ).

% subset_not_subset_eq
thf(fact_199_subset__psubset__trans,axiom,
    ! [A: $tType,A4: set @ A,B6: set @ A,C4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A4 @ B6 )
     => ( ( ord_less @ ( set @ A ) @ B6 @ C4 )
       => ( ord_less @ ( set @ A ) @ A4 @ C4 ) ) ) ).

% subset_psubset_trans
thf(fact_200_subset__iff__psubset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A6: set @ A,B7: set @ A] :
            ( ( ord_less @ ( set @ A ) @ A6 @ B7 )
            | ( A6 = B7 ) ) ) ) ).

% subset_iff_psubset_eq
thf(fact_201_monoseq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( topological_monoseq @ A )
        = ( ^ [X4: nat > A] :
              ( ( order_mono @ nat @ A @ X4 )
              | ( order_antimono @ nat @ A @ X4 ) ) ) ) ) ).

% monoseq_iff
thf(fact_202_monoI1,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X6: nat > A] :
          ( ! [M4: nat,N3: nat] :
              ( ( ord_less_eq @ nat @ M4 @ N3 )
             => ( ord_less_eq @ A @ ( X6 @ M4 ) @ ( X6 @ N3 ) ) )
         => ( topological_monoseq @ A @ X6 ) ) ) ).

% monoI1
thf(fact_203_incseq__imp__monoseq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X6: nat > A] :
          ( ( order_mono @ nat @ A @ X6 )
         => ( topological_monoseq @ A @ X6 ) ) ) ).

% incseq_imp_monoseq
thf(fact_204_decseq__imp__monoseq,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X6: nat > A] :
          ( ( order_antimono @ nat @ A @ X6 )
         => ( topological_monoseq @ A @ X6 ) ) ) ).

% decseq_imp_monoseq
thf(fact_205_monoseq__def,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( topological_monoseq @ A )
        = ( ^ [X4: nat > A] :
              ( ! [M: nat,N: nat] :
                  ( ( ord_less_eq @ nat @ M @ N )
                 => ( ord_less_eq @ A @ ( X4 @ M ) @ ( X4 @ N ) ) )
              | ! [M: nat,N: nat] :
                  ( ( ord_less_eq @ nat @ M @ N )
                 => ( ord_less_eq @ A @ ( X4 @ N ) @ ( X4 @ M ) ) ) ) ) ) ) ).

% monoseq_def
thf(fact_206_monoI2,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X6: nat > A] :
          ( ! [M4: nat,N3: nat] :
              ( ( ord_less_eq @ nat @ M4 @ N3 )
             => ( ord_less_eq @ A @ ( X6 @ N3 ) @ ( X6 @ M4 ) ) )
         => ( topological_monoseq @ A @ X6 ) ) ) ).

% monoI2
thf(fact_207_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A @ ( type2 @ A ) )
     => ! [X: A,Y4: A] :
          ( ( X != Y4 )
         => ( ~ ( ord_less @ A @ X @ Y4 )
           => ( ord_less @ A @ Y4 @ X ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_208_linordered__field__no__ub,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [X5: A] :
        ? [X12: A] : ( ord_less @ A @ X5 @ X12 ) ) ).

% linordered_field_no_ub
thf(fact_209_linordered__field__no__lb,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A @ ( type2 @ A ) )
     => ! [X5: A] :
        ? [Y: A] : ( ord_less @ A @ Y @ X5 ) ) ).

% linordered_field_no_lb
thf(fact_210_dependent__wellorder__choice,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ A @ ( type2 @ A ) )
     => ! [P: ( A > B ) > A > B > $o] :
          ( ! [R: B,F4: A > B,G3: A > B,X2: A] :
              ( ! [Y5: A] :
                  ( ( ord_less @ A @ Y5 @ X2 )
                 => ( ( F4 @ Y5 )
                    = ( G3 @ Y5 ) ) )
             => ( ( P @ F4 @ X2 @ R )
                = ( P @ G3 @ X2 @ R ) ) )
         => ( ! [X2: A,F4: A > B] :
                ( ! [Y5: A] :
                    ( ( ord_less @ A @ Y5 @ X2 )
                   => ( P @ F4 @ Y5 @ ( F4 @ Y5 ) ) )
               => ? [X1: B] : ( P @ F4 @ X2 @ X1 ) )
           => ? [F4: A > B] :
              ! [X5: A] : ( P @ F4 @ X5 @ ( F4 @ X5 ) ) ) ) ) ).

% dependent_wellorder_choice
thf(fact_211_order_Oordering__axioms,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ordering @ A @ ( ord_less_eq @ A ) @ ( ord_less @ A ) ) ) ).

% order.ordering_axioms
thf(fact_212_ordering__def,axiom,
    ! [A: $tType] :
      ( ( ordering @ A )
      = ( ^ [Less_eq: A > A > $o,Less: A > A > $o] :
            ( ! [A5: A,B5: A] :
                ( ( Less @ A5 @ B5 )
                = ( ( Less_eq @ A5 @ B5 )
                  & ( A5 != B5 ) ) )
            & ! [A5: A] : ( Less_eq @ A5 @ A5 )
            & ! [A5: A,B5: A] :
                ( ( Less_eq @ A5 @ B5 )
               => ( ( Less_eq @ B5 @ A5 )
                 => ( A5 = B5 ) ) )
            & ! [A5: A,B5: A,C5: A] :
                ( ( Less_eq @ A5 @ B5 )
               => ( ( Less_eq @ B5 @ C5 )
                 => ( Less_eq @ A5 @ C5 ) ) ) ) ) ) ).

% ordering_def
thf(fact_213_ordering_Oasym,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less2 @ A2 @ B2 )
       => ~ ( Less2 @ B2 @ A2 ) ) ) ).

% ordering.asym
thf(fact_214_ordering_Orefl,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( Less_eq2 @ A2 @ A2 ) ) ).

% ordering.refl
thf(fact_215_ordering_Ointro,axiom,
    ! [A: $tType,Less2: A > A > $o,Less_eq2: A > A > $o] :
      ( ! [A3: A,B3: A] :
          ( ( Less2 @ A3 @ B3 )
          = ( ( Less_eq2 @ A3 @ B3 )
            & ( A3 != B3 ) ) )
     => ( ! [A3: A] : ( Less_eq2 @ A3 @ A3 )
       => ( ! [A3: A,B3: A] :
              ( ( Less_eq2 @ A3 @ B3 )
             => ( ( Less_eq2 @ B3 @ A3 )
               => ( A3 = B3 ) ) )
         => ( ! [A3: A,B3: A,C3: A] :
                ( ( Less_eq2 @ A3 @ B3 )
               => ( ( Less_eq2 @ B3 @ C3 )
                 => ( Less_eq2 @ A3 @ C3 ) ) )
           => ( ordering @ A @ Less_eq2 @ Less2 ) ) ) ) ) ).

% ordering.intro
thf(fact_216_ordering_Otrans,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A,C: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less_eq2 @ A2 @ B2 )
       => ( ( Less_eq2 @ B2 @ C )
         => ( Less_eq2 @ A2 @ C ) ) ) ) ).

% ordering.trans
thf(fact_217_ordering_Oirrefl,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ~ ( Less2 @ A2 @ A2 ) ) ).

% ordering.irrefl
thf(fact_218_ordering_Oantisym,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less_eq2 @ A2 @ B2 )
       => ( ( Less_eq2 @ B2 @ A2 )
         => ( A2 = B2 ) ) ) ) ).

% ordering.antisym
thf(fact_219_ordering_Ostrict__trans,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A,C: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less2 @ A2 @ B2 )
       => ( ( Less2 @ B2 @ C )
         => ( Less2 @ A2 @ C ) ) ) ) ).

% ordering.strict_trans
thf(fact_220_ordering_Ostrict__trans1,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A,C: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less_eq2 @ A2 @ B2 )
       => ( ( Less2 @ B2 @ C )
         => ( Less2 @ A2 @ C ) ) ) ) ).

% ordering.strict_trans1
thf(fact_221_ordering_Ostrict__trans2,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A,C: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less2 @ A2 @ B2 )
       => ( ( Less_eq2 @ B2 @ C )
         => ( Less2 @ A2 @ C ) ) ) ) ).

% ordering.strict_trans2
thf(fact_222_ordering_Oorder__iff__strict,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less_eq2 @ A2 @ B2 )
        = ( ( Less2 @ A2 @ B2 )
          | ( A2 = B2 ) ) ) ) ).

% ordering.order_iff_strict
thf(fact_223_ordering_Ostrict__iff__order,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less2 @ A2 @ B2 )
        = ( ( Less_eq2 @ A2 @ B2 )
          & ( A2 != B2 ) ) ) ) ).

% ordering.strict_iff_order
thf(fact_224_ordering_Ostrict__implies__order,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less2 @ A2 @ B2 )
       => ( Less_eq2 @ A2 @ B2 ) ) ) ).

% ordering.strict_implies_order
thf(fact_225_ordering_Ostrict__implies__not__eq,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( Less2 @ A2 @ B2 )
       => ( A2 != B2 ) ) ) ).

% ordering.strict_implies_not_eq
thf(fact_226_ordering_Onot__eq__order__implies__strict,axiom,
    ! [A: $tType,Less_eq2: A > A > $o,Less2: A > A > $o,A2: A,B2: A] :
      ( ( ordering @ A @ Less_eq2 @ Less2 )
     => ( ( A2 != B2 )
       => ( ( Less_eq2 @ A2 @ B2 )
         => ( Less2 @ A2 @ B2 ) ) ) ) ).

% ordering.not_eq_order_implies_strict

%----Subclasses (4)
thf(subcl_Orderings_Olinorder___HOL_Otype,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( type @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oord,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( ord @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Oorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( order @ A @ ( type2 @ A ) ) ) ).

thf(subcl_Orderings_Olinorder___Orderings_Opreorder,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ( preorder @ A @ ( type2 @ A ) ) ) ).

%----Type constructors (20)
thf(tcon_fun___Complete__Lattices_Ocomplete__lattice,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( comple187826305attice @ A8 @ ( type2 @ A8 ) )
     => ( comple187826305attice @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( preorder @ A8 @ ( type2 @ A8 ) )
     => ( preorder @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 @ ( type2 @ A8 ) )
     => ( order @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 @ ( type2 @ A8 ) )
     => ( ord @ ( A7 > A8 ) @ ( type2 @ ( A7 > A8 ) ) ) ) ).

thf(tcon_Nat_Onat___Conditionally__Complete__Lattices_Oconditionally__complete__linorder,axiom,
    condit1037483654norder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Opreorder_1,axiom,
    preorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Ono__top,axiom,
    no_top @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oorder_2,axiom,
    order @ nat @ ( type2 @ nat ) ).

thf(tcon_Nat_Onat___Orderings_Oord_3,axiom,
    ord @ nat @ ( type2 @ nat ) ).

thf(tcon_Set_Oset___Complete__Lattices_Ocomplete__lattice_4,axiom,
    ! [A7: $tType] : ( comple187826305attice @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_5,axiom,
    ! [A7: $tType] : ( preorder @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_6,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_7,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) @ ( type2 @ ( set @ A7 ) ) ) ).

thf(tcon_HOL_Obool___Complete__Lattices_Ocomplete__lattice_8,axiom,
    comple187826305attice @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_9,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_10,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_11,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_12,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Free types (1)
thf(tfree_0,hypothesis,
    linorder @ a @ ( type2 @ a ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    p @ a2 @ b ).

%------------------------------------------------------------------------------
